package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.Review;
import gov.va.vinci.dart.db.ReviewDAO;

public class ReviewDAOMock implements ReviewDAO {

	private static HashMap<Integer,Review> IDHash = new HashMap<Integer,Review>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(Review review) {
		if (review == null) {
			throw new IllegalArgumentException();
		}

		initializeReviewHash();
		
		if (review.getId() == 0) {
			review.setId(idCounter++);
		}
		
		IDHash.put(review.getId(), review);
	}

	@Override
	public void delete(Review review) {
		if (review == null) {
			throw new IllegalArgumentException();
		}
		
		IDHash.remove(review.getId());
	}

	@Override
	public Review findById(int reviewId) {
		initializeReviewHash();
		
		return IDHash.get(reviewId);
	}

	@Override
	public List<Review> listAll() {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	@Override
	public List<Review> listByRequestId(int requestId) {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			Review review = IDHash.get(id);
			if (review.getRequest().getId() == requestId) {
				result.add(review);
			}
		}

		return result;	
	}

	@Override
	public List<Review> listByRequestIdAndWorkflowId(final int requestId, final int workflowId) {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			Review review = IDHash.get(id);
			
			if (review.getRequest() != null && review.getRequest().getId() == requestId) {

				if( review.getWorkflow() != null ) {
					if( review.getWorkflow().getId() == workflowId ) {
						result.add(review);
					}
				} else {	//NO workflowId, so it's an older NDS workflow (no workflow entry)
					result.add(review);
				}//end else
			}
		}

		return result;	
	}	

	@Override
	public List<Review> listByWorkflowId(final int workflowId) {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			Review review = IDHash.get(id);
			
			if( review.getWorkflow() != null ) {	//have a workflow attached to this review
				if( review.getWorkflow().getId() == workflowId ) {
					result.add(review);
				}
			}//end else
		}

		return result;	
	}	
	
	@Override
	public List<Review> listByGroupId(int groupId) {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			Review review = IDHash.get(id);
			if (review.getReviewer().getId() == groupId) {
				result.add(review);
			}
		}

		return result;	
	}

	@Override
	public List<Review> listByRequestIdAndGroupId(final int requestId, final int groupId) {
		List<Review> result = new ArrayList<Review>();
		
		initializeReviewHash();
		
		for (Integer id: IDHash.keySet()) {
			Review review = IDHash.get(id);

			if (review.getRequest() != null && review.getRequest().getId() == requestId) {

				if( review.getReviewer() != null && review.getReviewer().getId() == groupId ) {

					result.add(review);

				}
			}
		}

		return result;	
	}	
	
	private void initializeReviewHash() {
	
		if (initialized == true) {
			return;
		}
		
		initialized = true;
	}
	

}
